define(['HealthMoodNotificationStatusController', 'HealthMoodConstants', 'moment'], function() {
	'use strict';

	describe("The Health Notification Status Controller", function (){
		var q,
			scope,
			state,
			stateParams,
			serviceMock,
			graphServiceMock,
			remindersServiceMock,
			focusServiceMock,
			idGetterSpy,
			fetchSpy,
			deferredReminder,
			dataPointers = {},
			section = "glucose",
			sectionName = "Glucose",
			parsedItemId = "parsed_item_id";

		beforeEach(function() {
			module('angularTemplateApp');

			serviceMock = jasmine.createSpyObj('HealthMoodService', ['instance']);
			graphServiceMock = jasmine.createSpyObj('HealthMoodGraphService', ['getGraphConfig']);
			remindersServiceMock = jasmine.createSpyObj('HealthMoodRemindersService', ['init', 'getReminder']);
			focusServiceMock = jasmine.createSpyObj('focusService', ['focusElement']);
			idGetterSpy = jasmine.createSpy("idGetterSpy").and.returnValue(parsedItemId);
			fetchSpy = jasmine.createSpy("fetchSpy");

			module(function($provide){
				$provide.value('HealthMoodService', serviceMock);
				$provide.value('HealthMoodGraphService', graphServiceMock);
				$provide.value('HealthMoodRemindersService', remindersServiceMock);
				$provide.value('focusService', focusServiceMock);
			});

			inject(function($controller, $rootScope, $stateParams, $state, $q) {
				scope = $rootScope.$new();
				stateParams = $stateParams;
				state = $state;
				q = $q;

				var deferred = q.defer();
				serviceMock.instance.and.returnValue({
					dataPointers: dataPointers,
					idGetter: idGetterSpy,
					fetch: fetchSpy
				});
				deferred.resolve('resolved');
				fetchSpy.and.returnValue(deferred.promise);

				deferredReminder = q.defer();
				remindersServiceMock.getReminder.and.returnValue(deferredReminder.promise);

				stateParams.section = section;
				state.current.data = {
					sectionName: sectionName
				};

				scope.details = {
					notificationStatus: "On",
					eventDate: "01/01/01",
					frequency: "Daily",
					times: [{value: "09:00"}],
					notificationTypes: ['In-App']
				};

				$controller('HealthMoodNotificationStatusController', { $scope: scope, $stateParams: stateParams, $state: state });
			});
		});

		describe("scope variables", function() {
			it("should be defined and correct", function() {
				deferredReminder.resolve('resolved');
				scope.$apply();

				expect(scope.section).toBe('glucose');
				expect(scope.sectionTitle).toBe(sectionName);
				expect(scope.entryForm).toEqual({ service : { init : remindersServiceMock.init, getReminder : remindersServiceMock.getReminder }, callbacks : { common : jasmine.any(Function) }, allowedActions : { save : true, cancel : true } });
				expect(scope.details).toBe('resolved');
			});

			it("scope functions should be correct", function () {
				spyOn(state, 'go');
				scope.details = null;
				scope.entryForm.callbacks.common();
				expect(state.go).toHaveBeenCalledWith(undefined, { section : 'glucose', id : 'parsed_item_id' });
			});
		});

		describe("the notification watch", function() {
			it("should clear models if status is off", function() {
				scope.details.notificationStatus = "Off";
				expect(scope.details).toEqual({
					notificationStatus: "Off",
					eventDate: "01/01/01",
					frequency: "Daily",
					times: [{value: "09:00"}],
					notificationTypes: ['In-App']
				});

				scope.$apply();

				expect(scope.details).toEqual({
					notificationStatus: "Off",
					eventDate: "",
					frequency: "",
					times: [{value: ""}],
					notificationTypes: []
				});
			});

			it("shouldn't change models if status is on", function() {
				expect(scope.details).toEqual({
					notificationStatus: "On",
					eventDate: "01/01/01",
					frequency: "Daily",
					times: [{value: "09:00"}],
					notificationTypes: ['In-App']
				});

				scope.$apply();

				expect(scope.details).toEqual({
					notificationStatus: "On",
					eventDate: "01/01/01",
					frequency: "Daily",
					times: [{value: "09:00"}],
					notificationTypes: ['In-App']
				});
			});
		});
	});
});